﻿using gov.va.med.vbecs.Common;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace WPF.PresentationLayer.Controls
{
    public class ButtonStateTooltip : Button
    {
        #region Properties
        public string EnabledTooltip
        {
            get { return base.GetValue(EnabledTooltipProperty) as string; }
            set { base.SetValue(EnabledTooltipProperty, value); }
        }
        public static readonly DependencyProperty EnabledTooltipProperty =
          DependencyProperty.Register("EnabledTooltip", typeof(string), typeof(ButtonStateTooltip));

        public string DisabledTooltip
        {
            get { return base.GetValue(DisabledTooltipProperty) as string; }
            set { base.SetValue(DisabledTooltipProperty, value); }
        }
        public static readonly DependencyProperty DisabledTooltipProperty =
          DependencyProperty.Register("DisabledTooltip", typeof(string), typeof(ButtonStateTooltip));
        #endregion

        public ButtonStateTooltip()
        {
            this.IsEnabledChanged += ButtonTooltip_IsEnabledChanged;
        }

        private void ButtonTooltip_IsEnabledChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            if (this.IsEnabled)
            {
                this.ToolTip = EnabledTooltip;
            }
            else
            {
                this.ToolTip = DisabledTooltip;
            }
        }
    }
}
